// Menu JavaScript

var upTime = 400; // time in ms for menu to stay open
var overlap = 2; // number of pixels that the submenu overlaps the parent menu

var menuLeftAdjustment = 0;	// left adjustment
var menuTopAdjustment = 0;	// top adjustment

var spacer = "<img src='" + IMAGE_DIRECTORY + "spacer.gif' width='1px' height='1px'>";

var tracker = 0;
var currentHoverObject = "";
var menuWidth = 200;

var RIGHT_DIRECTION = 0;
var LEFT_DIRECTION = 0;

var menuDirection;

/**
 * Sets the timeout on clearing the menu from an onMouseOut event
 **/
function timer() {
	var menuItem = getMenu(currentHoverObject);
	var menuItems = getMenuItems(menuItem[0]);
	if (menuItems.length > 0) {
		keeper();
		setTimeout("clearLast(" + tracker + ")", upTime);
	} else {
		clearLast(tracker);
	}
}
/**
 * Clears the menu if the tracker has not been incremented (keeper() has not been called from an onMouseOver event)
 **/
function clearLast(track) {
	if (track == tracker) {
		document.getElementById("menu").innerHTML = "";
		if (currentHoverObject != "") document.getElementById(currentHoverObject).className='menu_fill';
	}
}

/**
 * Increments the tracker
 **/
function keeper() {
	tracker++;
}

/**
 * Immediately clears a submenu
 * @param the submenu to be cleared
 **/
function clearNow(subMenu) {
	document.getElementById(subMenu).innerHTML = "";
}

/**
 * MENU_ITEMS = [ [id, parent_id, title, link], ...]
 */
function getMenu(sourceObject) {
	for (var i = 0; i < MENU_ITEMS.length; i++) {
		if (MENU_ITEMS[i][0] == sourceObject.substr(5, sourceObject.length)) return MENU_ITEMS[i];
	}
}

function getMenuItems(parentID) {
	var menus = Array();
	for (var i = 0; i < MENU_ITEMS.length; i++) {
		if (MENU_ITEMS[i][1] == parentID) menus.push(MENU_ITEMS[i]);
	}
	return menus;
}

/**
 * Draws the menu relative to the position of the main menu
 * @param sourceObject the main menu link selected
 **/
function drawMenu(sourceObject) {
	keeper();
	clearLast(tracker);
	this.currentHoverObject = sourceObject;

	var m = document.getElementById("menu");
	var s = document.getElementById(sourceObject);

	var leftOffsetMenu = getOffsetLeft(s);
	var topOffsetMenu = getOffsetTop(s);

	var leftOffset = menuLeftAdjustment + leftOffsetMenu;
	var topOffset = menuTopAdjustment + topOffsetMenu + s.clientHeight;

	// draw menu links
	var menuItem = getMenu(sourceObject);
	var menuItems = getMenuItems(menuItem[0]);

	s.className = "menu_fill_hover";

	if (menuItems.length == 0) return;

	// draw initial submenu div and menu titlebar
	var menuContent = "<div id='menu_I' style='position: absolute'></div><table width='" + menuWidth + "px' border='0' cellspacing='0' cellpadding='0'><tr class='menu_box'><td colspan='3'>" + spacer + "</td></tr>";

	for (var i = 0; i < menuItems.length; i++) {
		menuContent += "<tr><td class='menu_box' width='1px'>" + spacer + "</td>";
		menuContent += "<td width='100%' id='menu_" + menuItems[i][0] + "' class='sub_menu_fill' onMouseOver=\"this.className='sub_menu_fill_hover'; keeper(); drawSubMenu('menu_" + menuItems[i][0] + "', 'menu_I');\" onMouseOut=\"timer(); this.className='sub_menu_fill';\" onClick=\"window.location='" + HTTP_ADDRESS + "index.php?page=items&category_id=" + menuItems[i][0] + "'\">" + menuItems[i][2] + "</td>";
		menuContent += "<td class='menu_box' width='1px'>" + spacer + "</td></tr>";

		// divider
		if (i < menuItems.length - 1) menuContent += "<tr><td class='menu_box' colspan='3'>" + spacer + "</td></tr>";
	}

	if (leftOffset - (document.body.clientWidth - 760) / 2 > 760 - menuWidth) leftOffset = leftOffset - menuWidth + s.clientWidth + 1;
	
	m.style.left = leftOffset;
	m.style.top = topOffset;
	m.innerHTML = menuContent + "<tr class='menu_box'><td colspan='3'>" + spacer + "</td></tr></table>";
}

/**
 * Draws the submenu relative to the position of the menu
 * @param contents the contents of the submenu in the format Array('displayLink', 'linkHref' [, Array(subMenu)])
 * @param sourceObject the menu link selected
 * @param destObject the div where the menu will be inserted
 * @param width the with of the submenu
 **/
function drawSubMenu(sourceObject, destObject) {
	keeper();

	var m = document.getElementById(destObject);

	// draw menu links
	var menuItem = getMenu(sourceObject);
	var menuItems = getMenuItems(menuItem[0]);

	if (menuItems.length == 0) {
		clearNow(destObject);
		return;
	}

	// draw initial submenu div and menu titlebar
	var menuContent = "<div id='" + destObject + "I' style='position: absolute'></div><table width='" + menuWidth + "px' border='0' cellspacing='0' cellpadding='0'><tr class='menu_box'><td colspan='3'>" + spacer + "</td></tr>";

	for (var i = 0; i < menuItems.length; i++) {
		if (i == 0) menuContent += "<tr><td class='menu_box_blank' width='1px'>" + spacer + "</td>";
		else menuContent += "<tr><td class='menu_box' width='1px'>" + spacer + "</td>";

		menuContent += "<td id='menu_" + menuItems[i][0] + "' class='sub_menu_fill' onMouseOver=\"this.className='sub_menu_fill_hover'; keeper(); drawSubMenu('menu_" + menuItems[i][0] + "', '" + destObject + "I');\" onMouseOut=\"timer(); this.className='sub_menu_fill';\" onClick=\"window.location='" + HTTPS_ADDRESS + "index.php?page=products&category_id=" + menuItems[i][0] + "'\">" + menuItems[i][2];
		menuContent += "</td><td class='menu_box' width='1px'>" + spacer + "</td></tr>";

		// divider
		if (i < menuItems.length - 1) menuContent += "<tr><td class='menu_box' colspan='3'>" + spacer + "</td></tr>";
	}

	//if (leftOffset - (document.body.clientWidth - 760) / 2 > 760 - menuWidth) leftOffset = leftOffset - menuWidth + s.clientWidth;

	m.style.left = menuWidth - overlap;
	m.style.top = document.getElementById(sourceObject).offsetTop - 1;
	m.innerHTML = menuContent + "<tr class='menu_box'><td colspan='3'>" + spacer + "</td></tr></table>";
}