// Events Popup JavaScript
var infoBubbleWidth = 250;
var pad = 20; // padding between bubble and window border

function infoBubble(element, info) {
	hideBubble();
	
	var button = document.getElementById(element);
	var bubble = document.getElementById("info");
	var iframe = document.createElement("iframe");
	iframe.id = "info_iframe";
	iframe.style.borderWidth = 0;
	iframe.style.position = "absolute";

	bubble.style.visibility = "hidden";
	
	iframe.style.top = getOffsetTop(button);
	bubble.style.top = getOffsetTop(button);

	var leftOffset = getOffsetLeft(button);

	if (leftOffset + infoBubbleWidth < document.body.clientWidth - pad) {
		bubble.style.left = leftOffset + pad;
		iframe.style.left = leftOffset + pad;
	} else {
		bubble.style.left = leftOffset - infoBubbleWidth - pad + 14;
		iframe.style.left = leftOffset - infoBubbleWidth - pad + 14;
	}
	
	bubble.innerHTML = "<table width='" + infoBubbleWidth + "px' class='info_box' border='0' cellspacing='1' cellpadding='7'><tr><td class='info_fill'><a class='main_link' href='javascript:hideBubble();' title='Hide'><img border='0' align='right' src='images/close.gif' width='14px' height='14px' style='margin-left: 7px; margin-bottom: 2px;'></a>" + info + "</td></tr></table>";

	document.body.appendChild(iframe);
	iframe.style.width = bubble.clientWidth;
	iframe.style.height = bubble.clientHeight;
	
	bubble.style.visibility = "visible";
}

function hideBubble() {
	var iframe = document.getElementById("info_iframe");
	if (iframe != null) document.body.removeChild(iframe);
	document.getElementById("info").innerHTML = "";
}

window.onresize = function() {
	hideBubble();
}