<?php
// FUNCTIONS

// FILTER TYPES FOR STRING_FORMAT FUNCTION
define("FILTER_QUOTES", "[?\$<>]");
define("FILTER_ALL", "[?/.&\$<>]");

function string_format($str = "", $reg_exp = FILTER_ALL, $str_replacement = "") {
	return ereg_replace($reg_exp, $str_replacement, $str);
}

/**
 * Creates a random string with characters 1-10 and a-z
 * @param length the length of the random string
 */
function random_string($length = 10) {
	$rand_string = "";
	for ($i = 0; $i < $length; $i++) {
		$x = mt_rand(0, 35);
		if ($x > 9) $rand_string .= chr($x + 87);
		else $rand_string .= $x;
	}
	return $rand_string;
}

define("NO_EXTENTION", 0);
define("WITH_EXTENTION", 1);

function unique_file_name($folder, $extention = '', $temp_file_name = '', $return_extention = NO_EXTENTION) {
	if (empty($extention)) {
		if (!empty($temp_file_name)) {
			$temp_file_exploded = explode(".", $temp_file_name);
			$extention = $temp_file_exploded[count($temp_file_exploded) - 1];
		}
		else return "";
	}

	$file_name = random_string();
	while(file_exists($folder . $file_name . "/" . $extention))	$file_name = random_string();

	switch ($return_extention) {
	case NO_EXTENTION:
		return $file_name;
	case WITH_EXTENTION:
		return $file_name . $extention;
	}
}

function draw_message($message) {
	if (!empty($message)) echo "<table width='100%' class='message_box' border='0' cellspacing='1' cellpadding='7'><tr class='message_fill'><td><div style='text-indent: 15px; text-align: justify;'>" . $message . "</div></td></tr></table><br>";
}

function draw_important_message($message) {
	if (!empty($message)) echo "<table width='100%' class='important_message_box' border='0' cellspacing='1' cellpadding='7'><tr class='important_message_fill'><td>" . $message . "</td></tr></table><br>";
}

function draw_success_message($message) {
	if (!empty($message)) echo "<table width='100%' class='success_message_box' border='0' cellspacing='1' cellpadding='7'><tr class='success_message_fill'><td>" . $message . "</td></tr></table><br>";
}

function draw_title_bar($title, $class="title_bar") {
	if (!empty($title)) {
		echo "<div class='line_no_margin'><img src='images/spacer.gif' width='100%' height='1px'></div><div class='".$class."'>" . $title . "</div><img src='images/shadow.gif' width='100%' height='5px'><br><img src='images/spacer.gif' width='100%' height='2px'><br>";
	}
}

function draw_line($class = "no_margin_line", $image_directory = IMAGE_DIRECTORY) {
	echo "<div class=" . $class . "><img src=" . $image_directory . "spacer.gif' width='1px' height='1px'></div>";
}

function abbreviated_string($str, $max_length = 20) {
	if (strlen($str) > $max_length) $str = substr($str, 0, $max_length - 3) . "...";
	return $str;
}

function format_time($time) {
	if (empty($time)) return "";
	else if (substr($time, 0, 2) == 24) return "12:" . substr($time, 2, 4) . "am";
	else if (substr($time, 0, 2) == 12) return "12:" . substr($time, 2, 4) . "pm";
	else if (substr($time, 0, 2) > 12) return (substr($time, 0, 2) - 12) . ":" . substr($time, 2, 4) . "pm";
	else return number_format(substr($time, 0, 2), 0) . ":" . substr($time, 2, 4) . "am";
}

function format_timestamp($time) {
	if (!empty($time)) return substr($time, 4, 2) . "-" . substr($time, 6, 2) . "-" . substr($time, 0, 4) . "&nbsp;&nbsp;&nbsp;" . substr($time, 8, 2) . ":" . substr($time, 10, 2) . ":" . substr($time, 12, 2);
	else return "";
}

function format_timestamp_short($time) {
	if (!empty($time)) return substr($time, 4, 2) . "-" . substr($time, 6, 2) . "-" . substr($time, 2, 2) . " " . substr($time, 8, 2) . ":" . substr($time, 10, 2);
	else return "";
}

function format_date($date) {
	if (!empty($date)) return substr($date, 4, 2) . "-" . substr($date, 6, 2) . "-" . substr($date, 0, 4);
	else return "";
}

function highlight($offset = 1) {
	if (!isset($GLOBALS['highlight_count'])) reset_highlight();
	if(($GLOBALS['highlight_count'] + $offset) % 2  == 0) $highlight = " class='highlight_white'";
	else $highlight = " class='highlight_black'";
	$GLOBALS['highlight_count']++;
	return $highlight;
}

function reset_highlight() {
	$GLOBALS['highlight_count'] = 0;
}

/*
 * Output 'select' tag with its field name, values and default value(for numeric fields)
*/
function draw_numbers_select_field($field_name, $field_value, $start, $end, $step = 1, $class = "") {
	echo "<select name='$field_name' class='$class'>";
	$options = "";
	for ($i = $start; $i <= $end; $i = $i + $step) {
		$options .= "<option value='" . $i . "' ";
		$options .= ($i == $field_value) ? "selected='selected' " : "";
		$options .= ">" . $i . "</option>";
	}
	if($options=="")$options .= "Not Available";
	echo "$options</select>";
}

function draw_month_select() {
	$tempMonths = array('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
	for ($i = 1; $i <= 12; $i++) {
		if ($i < 10) $tempNum = "0" . $i;
		else $tempNum = $i;
		echo "<option value='" . $tempNum . "'>" . $tempMonths[$i] . "</option>";
	}
}

function draw_year_select($start_year, $end_year) {
	for ($i = $start_year; $i <= $end_year; $i++) echo "<option value='" . $i . "'>" . $i . "</option>";
}

function convert_newlines($text) {
	return ereg_replace("\n", "<br>", htmlspecialchars($text, ENT_QUOTES));
}

define("GET_VARIABLE_TAG", 0);
define("GET_VARIABLE_HIDDEN_FIELDS", 1);

function get_vars($return_type, $exclude_keys = array()) {
	// use implode
	if (!empty($_GET)) {
		$get_keys = array_keys($_GET);
		foreach ($get_keys as $key) {
			if (!empty($key)) {
				if (!in_array($key, $exclude_keys)) {
					if ($key_count++ > 0) $link_tag .= "&";
					$link_tag .= $key . "=" . $_GET[$key];
					$hidden_fields .= "<input type='hidden' name='" . $key . "' value='" . $_GET[$key] . "'>";
				}
			}
		}
	}
	if ($return_type == 0) return $link_tag;
	else if ($return_type == 1) return $hidden_fields;
	else return "";
}







function array_search_level($needle, $haystack, $level) {
	if (!is_array($haystack)) return false;

	foreach ($haystack as $key => $hay)
		if ($needle === $hay[$level] . "")
			return $key;

	return false;
}

function array_string($arr, $sep) {
	if (!array($arr)) return "";
	
	$arr_str = "";
	foreach ($arr as $val) {
		if (!empty($arr_str)) $arr_str .= $sep;
		$arr_str .= $val;
	}

	return $arr_str;
}

function array_string_extended($arr, $key_val_sep, $sep) {
	if (!array($arr)) return "";
	
	$arr_str = "";
	foreach ($arr as $key => $val) {
		if (!empty($arr_str)) $arr_str .= $sep;
		if (!is_array($val)) $arr_str .= $key . $key_val_sep . "'" . $val . "'";
		else $arr_str .= $key . $val[0] . "'" . $val[1] . "'";
	}

	return $arr_str;
}

function array_sort_hierarchal($arr, $id_column, $parent_id_column,  $parent_id = 0, $level = 0) {
	$hierarchal_array = array();

	for ($i = 0; $i < count($arr); $i++) {
		if ($arr[$i][$parent_id_column] == $parent_id) {
			$arr[$i]['hierarchal_level'] = $level;
			array_push($hierarchal_array, $arr[$i]);
			$hierarchal_array = array_merge($hierarchal_array, array_sort_hierarchal($arr, $id_column, $parent_id_column, $arr[$i][$id_column], $level + 1));
		}
	}

	return $hierarchal_array;
}

function My_SendMail($mail_to, $msg_title, $message, $from){   
    // create email headers
    $headers = 'From: '.$from."\r\n";
    $headers .= 'Reply-To: '.$from."\r\n" . 'X-Mailer: PHP/' . phpversion();

    // To send HTML mail, the Content-type header must be set
    $headers .= 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
    
    @mail($mail_to, $msg_title, $message, $headers);
}

function get_random_string($length = 20) {
	$template = "1234567890abcdefghijklmnopqrstuvwxyz";
	settype($template, "string");
	settype($length, "integer");
	settype($rndstring, "string");
	settype($a, "integer");
	settype($b, "integer");           
	for ($a = 0; $a <= $length; $a++) {
		$b = rand(0, strlen($template) - 1);
		$rndstring .= $template[$b];
	}       
	return $rndstring;       
}


function draw_countries($selected_country = "", $country_name = "country", $state_name = "state", $onchange = false, $draw_js = false, $state_title = false) {
	//onchange='state_cities(this.value)'
	$output = "<select class='form_select' id='".$country_name."' name='".$country_name."' onchange='".(($onchange) ? $state_name."_country_states(this.value)" : "")."'>";
		$output .= "<option value=''>-- select --</option>";
		$countries=database_query("SELECT * FROM countries ORDER BY name ASC", DATA_ONLY);
		foreach ($countries as $country) {				
			if ($selected_country != $country['id']){
				$output .= "<option value='" . $country['id'] . "'>" . $country['name'] . "</option>";
			}else{
				$output .= "<option value='" . $country['id'] . "' selected='selected'>" . $country['name'] . "</option>";				
			}
		}
	$output .= "</select>";

	if($draw_js){
		$countries = database_query("SELECT * FROM countries ORDER BY name ASC", DATA_ONLY);		
		$output .= "\n<script>\n";
		$output .= "var states = new Array(); \n";
		foreach ($countries as $country) {
			$states=database_query("SELECT * FROM states WHERE country_id='".$country['id']."' ORDER BY name ASC",DATA_ONLY);
			$i=0;
			$output.= "states['".$country['id']."'] = new Array();\n";			
			foreach($states as $state) {
				$output.= "states['".$country['id']."'][".$i."]='".(($state_title) ? $state['title'] : $state['id']).",".$state['name']."';\n";
				$i++;
			}
		}
		$output .= "</script>";		
	
		$output .="<script>
		function ".$state_name."_country_states(country) {				
			stateDdl = document.getElementById('".$state_name."');
			stateDdl.options.length = 0;
			stateDdl.options[0] = new Option('-- select --','0');
			if(country == '') return false;
			len = states[country].length;			
			for(i = 1; i <= len; i++){
				if(states[country][i-1]){
					state_data = states[country][i-1];
					state_data_splitted = state_data.split(',');
					//alert(state_data_splitted[0]+' '+state_data_splitted[1]);
					stateDdl.options[i] = new Option(state_data_splitted[1],state_data_splitted[0]);					
				}
			}
			if(document.getElementById('city')){
				cityDdl = document.getElementById('city');
				cityDdl.options.length = 1;
				cityDdl.options[0] = new Option('-- select --','0');								
			}
		}		
		</script>";

	}	
	
	return $output;
}

function draw_states($selected_state = "", $state_name = "state") {
	
	$output = "<select class='form_select' id='".$state_name."' name='".$state_name."' onchange='state_cities(this.value)'>";
		$output .= "<option value=''>-- select --</option>";
		$states=database_query("SELECT * FROM states ORDER BY name ASC", DATA_ONLY);
		foreach ($states as $state) {				
			if ($selected_state != $state['title']){
				$output .= "<option value='" . $state['title'] . "'>" . $state['name'] . "</option>";
			}else{
				$output .= "<option value='" . $state['title'] . "' selected='selected'>" . $state['name'] . "</option>";				
			}
		}
	$output .= "</select>";

	$states = database_query("SELECT * FROM states ORDER BY name ASC", DATA_ONLY);		
	$output .= "\n<script>\n";
	$output .= "var cities = new Array(); \n";
	foreach ($states as $state) {
		$cities=database_query("SELECT * FROM cities WHERE state_title='".$state['title']."' ORDER BY name ASC",DATA_ONLY);
		$i=0;
		$output.= "cities['".$state['title']."'] = new Array();\n";			
		foreach($cities as $city) {
			$output.= "cities['".$state['title']."'][".$i."]='".$city['id'].",".$city['name']."';\n";
			$i++;
		}
	}
	$output .= "</script>";		
	
	$output .="<script>
	function state_cities(state) {
		//alert(state);
		if(cities[state]){
			len = cities[state].length;
			//alert(state+' ' + len);
			cityDdl = document.getElementById('city');
			cityDdl.options.length = 0;
			cityDdl.options[0] = new Option('-- select --','0');
			for(i = 1; i <= len; i++){
				if(cities[state][i-1]){
					city_data = cities[state][i-1];
					city_data_splitted = city_data.split(',');
					//alert(city_data_splitted[0]+' '+city_data_splitted[1]);
					cityDdl.options[i] = new Option(city_data_splitted[1],city_data_splitted[0]);					
				}
			}			
		}else{
			cityDdl.options.length = 1;
			cityDdl.options[0] = new Option('-- select --','0');
		}
	}		
	</script>";
	return $output;
}


function draw_cities($state, $selected_city) {
			
	$sql = "SELECT * FROM cities WHERE state_title = '".$state."' ORDER BY name ASC";
	$cities=database_query($sql,DATA_ONLY);		
	$output = "<select class='form_select' id='city' name='city'>";
	$output .= "<option value=''>-- select --</option>";
	foreach ($cities as $city) {
		if ($selected_city != $city['id']){
			$output .= "<option value='" . $city['id'] . "'>" . $city['name'] . "</option>";
		}else{
			$output .= "<option value='" . $city['id'] . "' selected='selected'>" . $city['name'] . "</option>";	
		}
	}
	$output .= "</select>";

	return $output;
}

////////////////////////////////////////////////////////////////////////////////
function check_email_address($email) {
    // First, we check that there's one @ symbol, and that the lengths are right
    if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
        // Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
        return false;
    }
    // Split it into sections to make life easier
    $email_array = explode("@", $email);
    $local_array = explode(".", $email_array[0]);
    for ($i = 0; $i < sizeof($local_array); $i++) {
         if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
            return false;
        }
    }    
    if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
        $domain_array = explode(".", $email_array[1]);
        if (sizeof($domain_array) < 2) {
                return false; // Not enough parts to domain
        }
        for ($i = 0; $i < sizeof($domain_array); $i++) {
            if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
                return false;
            }
        }
    }
    return true;
}

function check_date_format($date){
	$date_splitted = split("/",$date);
	if(count($date_splitted) < 3){
		return false;
	}else{
		if (!(is_numeric($date_splitted[0]) && ($date_splitted[0] <=12))) return false;
		if (!(is_numeric($date_splitted[1]) && ($date_splitted[1] <=31))) return false;
		if (! (is_numeric($date_splitted[2]) &&
			  ($date_splitted[2] < date("Y")) &&
			  ($date_splitted[2] > (date("Y") - 100))
			  )
		   ) return false;
	}
	return true;
}

function get_formatted_microtime(){
	list($usec, $sec) = explode(' ', microtime());
	return ((float)$usec + (float)$sec);
}

function draw_datetime_field($field_name, $field_value="", $start_year="", $end_year="", $date_only = false) {
	$cur_year = date('Y');
	$cur_month = date('m');				
	$cur_day = date('d');				
	$cur_hour = date('H');
	$cur_minutes = date('i');
	$cur_seconds = date('s');
	if($field_value!=""){
		$arr_datetime = split(" ",$field_value);
		if(is_array($arr_datetime)){
			$arr_date = split("-",$arr_datetime[0]);
			$arr_time = split(":",$arr_datetime[1]);
			if(is_array($arr_date)){
				$cur_year = $arr_date[0];
				$cur_month = $arr_date[1];
				$cur_day = $arr_date[2];
			}
			if(is_array($arr_time)){
				$cur_hour = $arr_time[0];
				$cur_minutes = $arr_time[1];
				$cur_seconds = $arr_time[2];
			}
		}
	}
	if($start_year==""){
		$start_year = date('Y');
	}
	if($end_year==""){
		$end_year = $start_year+10;
	}
	$tempMonths = array('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

	// Year select
	$sel_year = "<select class='form_select' name='".$field_name."_year'>";
	for ($i = $start_year; $i <= $end_year; $i++){
		$sel_year .= "<option value='" . $i . "' ".(($i==$cur_year)?"selected":"")." >" . $i . "</option>";
	}
	$sel_year .= "</select>";



	// Month select
	$sel_month = "<select class='form_select' name='".$field_name."_month'>";
	for ($i = 1; $i <= 12; $i++) {
		if ($i < 10) $tempNum = "0" . $i;
		else $tempNum = $i;
		$sel_month .= "<option value='" . $tempNum . "' ".(($tempNum==$cur_month)?"selected":"")." >" . $tempMonths[$i] . "</option>";
	}
	$sel_month .= "</select>";



	// Day select
	$sel_day = "<select class='form_select' name='".$field_name."_day'>";
	for ($i = 1; $i <= 31; $i++) {
	if ($i < 10) $tempNum = "0" . $i;
		else $tempNum = $i;
		$sel_day .= "<option value='" . $tempNum . "' ".(($tempNum==$cur_day)?"selected":"")." >" . $i . "</option>";
	}
	$sel_day .= "</select>";

	
	if(!$date_only){
		// Hour select
		$sel_hour = "<select class='form_select' name='".$field_name."_hour'>";
		for ($i = 0; $i <= 23; $i++) {
			if ($i < 10) $tempNum = "0" . $i;
			else $tempNum = $i;
			$sel_hour .= "<option value='" . $tempNum . "' ".(($tempNum==$cur_hour)?"selected":"")." >" . $tempNum . "</option>";
		}
		$sel_hour .= "</select>";	
		
		// Minutes select
		$sel_minutes = "<select class='form_select' name='".$field_name."_minutes'>";
		for ($i = 0; $i <= 59; $i++) {
			if ($i < 10) $tempNum = "0" . $i;
			else $tempNum = $i;
			$sel_minutes .= "<option value='" . $tempNum . "' ".(($tempNum==$cur_minutes)?"selected":"")." >" . $tempNum . "</option>";
		}
		$sel_minutes .= "</select>"; 		
	}

	echo "<nobr>";
	echo $sel_year." ".$sel_month." ".$sel_day."&nbsp;&nbsp;&nbsp;&nbsp;".((!$date_only) ? $sel_hour." : ".$sel_minutes : "") ; 
	echo "</nobr>";
}

function isValidDateTime($dateTime) 
{ 

	$matches = "";
    if (preg_match("/^(\\d{4})-(\\d{2})-(\\d{2}) ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$/", $dateTime, $matches)) { 
        if (checkdate($matches[2], $matches[3], $matches[1])) { 
            return true; 
        } 
    } 
    return false; 

}

function isValidFloat($value) 
{ 
	return ( $value == strval(floatval($value)) )? true : false;
}

function draw_select_companies($field_name, $cur_company = -1, $param = "") {
	$res = database_query("SELECT * FROM companies",DATA_ONLY);
	echo "<select class='form_select' name='$field_name'>";

	if($param!="NO_ALL"){

		echo "<option value='-1' ".(($cur_company==-1)?"selected":"").">All Companies</option>";

	}

	foreach($res as $company){
		echo "<option value='".$company['id']."' ".(($company['id']==$cur_company)?"selected":"").">".$company['name']."</option>";
	}
	echo "</select>";
}

function draw_select_other_companies($field_name, $cur_company = "0", $choosen_company = "") {
	$res = database_query("SELECT * FROM companies WHERE id!=".$cur_company,DATA_ONLY);
	echo "<select class='form_select' name='$field_name'>";

	

		echo "<option value='-1'>All Companies</option>";

	

	foreach($res as $company){
		echo "<option value='".$company['id']."'".(($company['id']==$choosen_company)?"selected":"").">".$company['name']."</option>";
	}
	echo "</select>";
}



function draw_hidden_field($field_name, $field_value = "") {

	echo "<input type='hidden' name='$field_name' value='$field_value'>";

}


function draw_gender_select($field_name, $field_value=""){
	echo "<select class='form_select' name='$field_name'>";
	echo "	<option value='' ".(($field_value=="")?"selected":"").">Both</option>";
	echo "	<option value='M' ".(($field_value=="M")?"selected":"").">Male</option>";
	echo "	<option value='F' ".(($field_value=="F")?"selected":"").">Female</option>";
	echo "</select>";
}


// Adds in where clause condition for companyID
function belongs_the_company($table_name = ""){
	if($GLOBALS['user_session']->get_session_variable("session_company") != ""){
		return " AND ".(($table_name != "") ? $table_name."." : "")."company_id=".$GLOBALS['user_session']->get_session_variable("session_company");		
	}
	return "";
}


function company_select() {
	if($GLOBALS['user_session']->get_session_variable("session_company") != ""){
		$sql="SELECT company_id FROM accounts WHERE id=".$GLOBALS['user_session']->get_session_variable("session_account_id");
		if ($result=database_query($sql,DATA_ONLY,1)) {
			return " (company_id=".$result['company_id']." OR is_shared=1) AND companies.is_inactive=0";
		} else {
			return "";
		}
	}
	return "";

}

function working_account() {
	return "accounts.status IN (1,2)";
}

function view_permissions() {
	global $user_session;
	$status=$user_session->get_session_variable('session_account_status');
	if ($user_session->get_session_variable('session_is_banned')!=0) {

		return true;

	}

	return ( $status!= "approved") && ($status != "modified");
}

function drawBlockTop(){
	global $STYLE_;
	$block_top_image = "";
	$block_middle_image = "";

	if($STYLE_['block_top_image'] != "") $block_top_image = "height: 12px; background-image: url(images/".$STYLE_['block_top_image']."); background-repeat: no-repeat;";
	if($STYLE_['block_middle_image'] != "") $block_middle_image = "background-image: url(images/".$STYLE_['block_middle_image']."); background-repeat: repeat-y;";
	
	echo "<table class='main_text' width='100%' border=0 cellspacing=0 cellpadding=0>
		<tr><td style='".$block_top_image."'></td></tr>						
		<tr>
			<td wrap='wrap' style='word-wrap: break-word; padding-left:0px; padding-right:0px;".$block_middle_image."'>";
	
}


function drawBlockBottom(){
	global $STYLE_;
	$block_bottom_image = "";
	
	if($STYLE_['block_bottom_image'] != "") $block_bottom_image = "height: 12px; background-image: url(images/".$STYLE_['block_bottom_image']."); background-repeat: no-repeat;";
	
	echo "</td>
		</tr>
		<tr><td style='".$block_bottom_image."'></td></tr>						
		</table>";
}

function draw_ages($name, $selected_age){
	
	$output = "<select class='form_select' id='".$name."' name='".$name."'>";
	for($i=18; $i < 70; $i++){
		if($selected_age != $i){
			$output .= "<option value='".$i."'>".$i."</option>";				
		}else{
			$output .= "<option value='".$i."' selected='selected'>".$i."</option>";				
		}
	}
	$output .= "</select>";
	
	return $output;
}

function camelCase($string) {
	$arr_temp = explode(" ",$string);
	for($i=0;$i<count($arr_temp);$i++){
		$arr_temp[$i] = ucfirst($arr_temp[$i]);
	}
	$str = implode(" ",$arr_temp);
	return $str;
}

/**
 *	Remove bad chars from input
 *	  	@param $str_words - input
 **/
function remove_bad_chars($str_words)
{
	$found = false;
	$bad_string = array("select", "drop", ";", "--", "insert","delete", "xp_", "%20union%20", "/*", "*/union/*", "+union+", "load_file", "outfile", "document.cookie", "onmouse", "<script", "<iframe", "<applet", "<meta", "<style", "<form", "<img", "<body", "<link", "_GLOBALS", "_REQUEST", "_GET", "_POST", "include_path", "prefix", "http://", "https://", "ftp://", "smb://", "onmouseover=", "onmouseout=");
	for ($i = 0; $i < count($bad_string); $i++){
		$str_words = str_replace($bad_string[$i], "", $str_words);
	}
	return $str_words;            
}

/**
 *	Remove bad chars from input
 *	  	@param $str_words - input
 **/
function prepare_input($str_words, $escape = false)
{
	$found = false;
	$bad_string = array("select", "drop", ";", "--", "insert", "delete", "xp_", "%20union%20", "/*", "*/union/*", "+union+", "load_file", "outfile", "document.cookie", "onmouse", "<script", "<iframe", "<applet", "<meta", "<style", "<form", "<img", "<body", "<link", "_GLOBALS", "_REQUEST", "_GET", "_POST", "include_path", "prefix", "http://", "https://", "ftp://", "smb://", "onmouseover=", "onmouseout=");
	for($i = 0; $i < count($bad_string); $i++){
		$str_words = str_replace($bad_string[$i], "", $str_words);
	}
	
	if($escape){
		if(!get_magic_quotes_gpc()){
			$str_words = addslashes($str_words); 
		}		
	}
	
	return $str_words;            
}

/**
 *  Draw token hidden field (protection agains csrf attaks)
 *  		@param $draw
 */
function draw_token_field($draw = true)
{
	$token = isset($_SESSION["token"]) ? $_SESSION["token"] : '';	
	$output = "<input type='hidden' name='token' value='".$token."' />";
	if($draw) echo $output;
	else return $output;
}

?>