<?php
class Menu {
	private $id;
	protected $menu;
	public $error;
	
	function Menu($id = "") {
		$this->id = $id;
		if($this->id!=""){
			$sql = "SELECT * FROM ".DB_PREFIX."menus WHERE id = '".intval($this->id)."'";
			$this->menu = database_query($sql,DATA_ONLY,1);
		}else{
			$this->menu['menu_name'] = "";
			$this->menu['menu_order'] = "";
		}
	}
	
	public function getName(){		
		if(isset($this->menu['menu_name'])) return $this->menu['menu_name'];
		else return "";
	}
	
	public function getId(){
		return $this->id;
	}
	
	public function getOrder(){
		if(isset($this->menu['menu_order'])) return $this->menu['menu_order'];
		else return "";
	}
	
	function getAll($order = " menu_order ASC", $join_table = "") {
		// Build ORDER BY CLAUSE
		if($order=="")$order_clause = "";
		else $order_clause = "ORDER BY $order";

		// Build JOIN clause
		if($join_table=="") {
			$join_clause = "";
			$join_select_fields = "";
		}
		else {
			$join_clause = "INNER JOIN ".DB_PREFIX.$join_table." ON ".DB_PREFIX.$join_table.".menu_id=".DB_PREFIX."menus.id ";
			$join_select_fields = ", ".DB_PREFIX.$join_table.".* ";
		}
		
		$sql = "SELECT ".DB_PREFIX."menus.* $join_select_fields 
				FROM ".DB_PREFIX."menus
					$join_clause 
				$order_clause";
		$res =  database_query($sql,DATA_AND_ROWS);
		return $res;
	}
	
	
	function menuUpdate($params = Array()) {
		// Get input parameters
		if(isset($params['name']) && $params['name']!=""){
			$this->menu['menu_name'] = $params['name'];
		}else{
			$this->error = MENU_NAME_EMPTY;
			return false;
		}
		if(isset($params['order']))$this->menu['menu_order'] = $params['order'];
		
		if(isset($this->id)){
			$sql = "UPDATE ".DB_PREFIX."menus
					SET 
						menu_name = '".$this->menu['menu_name']."',
						menu_order = ".$this->menu['menu_order']."
					WHERE id = ".intval($this->id)."";
			if (database_void_query($sql)){
				return true;
			} else {
				$this->error = TRY_LATER;
				return false;
			}
		}else{
			$this->error = MENU_MISSED;
			return false;
		}
	}
	
	function menuCreate($params = Array()) {
		// Get input parameters
		if(isset($params['name']))$this->menu['menu_name'] = $params['name'];
		if(isset($params['order']))$this->menu['menu_order'] = $params['order'];

		// Prevent creating of empty records in our 'menus' table
		if($this->menu['menu_name']!=""){
			$sql = "INSERT INTO ".DB_PREFIX."menus(menu_name, menu_order)
					VALUES(
							'".$this->menu['menu_name']."',
							".$this->menu['menu_order']."
					)";
				if (database_void_query($sql)){
					$this->error = TRY_LATER;
					return true;
				} else {
					return false;
				}				
		}else{
			$this->error = MENU_NAME_EMPTY;
			return false;
		}
	}

	function menuDelete($menu_id = "") {
		$sql = "DELETE FROM ".DB_PREFIX."menus WHERE id = ".intval($menu_id)."";
		if (database_void_query($sql)) return true;

		return false;
	}

	function drawTree() {
		// Get all menus which have items (links to static pages)
		$menus = self::getAll("menu_order ASC","static_pages");

		// Display all menu titles (names) according to their order
		$cur_menu = "";
		$is_start = true;
		for($menu_ind = 0; $menu_ind < $menus[1]; $menu_ind++) {
				
			// Menu name has changed
			if($menus[0][$menu_ind]['menu_name'] != $cur_menu) { 
				
				// Save new menu name
				$cur_menu = $menus[0][$menu_ind]['menu_name'];   
			
				// End drawing current menu
				if(!$is_start) drawBlockBottom();
				else $is_start = false;           
				
				// Draw space line between menus
				if($menu_ind > "0") echo "<br>";                 
				
				// Start draw new menu
				drawBlockTop();
				echo "<table class='moduletable' width='100%' border=0 cellspacing=0 cellpadding=0>
				<tr><TH vAlign=top>".camelCase($menus[0][$menu_ind]['menu_name'])."</TH></TR>
				</table>";
					
                         		//echo "<strong class='title_link'></strong><br>";                               
			}
			// Draw current menu link
			echo "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link'
				href='" . HTTPS_ADDRESS . "index.php?page=static_pages&name=".$menus[0][$menu_ind]['page_key']."'>".camelCase($menus[0][$menu_ind]['menu_link'])."</a><br>";
		}
		// End drawing last menu
		if(!$is_start) drawBlockBottom();
	}
}
?>