<?php
define("LOGIN_REFERER", "");
define("LOGIN_ATTEMPT_TIMEOUT", 300);
define("LOGIN_ATTEMPT_TIME", 300);
define("LOGIN_ATTEMPTS_ALLOWED", 5);

class Login {
	private $wrong_login;
	private $messages;
	private $accounts;
	
	function Login() {

		$submit  = isset($_POST['submit']) ? remove_bad_chars($_POST['submit']) : "";
		$submit_logout = isset($_POST['submit_logout']) ? remove_bad_chars($_POST['submit_logout']) : "";
		$user_name     = isset($_POST['user_name']) ? prepare_input($_POST['user_name'], true) : "";
		$password      = isset($_POST['password']) ? prepare_input($_POST['password'], true) : "";

		$this->wrong_login = false;
		if (!$this->is_logged_in() && $submit == "Login" && !empty($user_name) && !empty($password)) $this->do_login($user_name, $password);
		else if ($submit_logout == "Logout") $this->do_logout();
		$this->accounts = new Profiles($GLOBALS['user_session']->get_session_variable("session_account_id"));
	}
	
	function do_login($user_name, $password, $do_redirect = true) {
		if ($account_information = $this->get_account_information($user_name, $password)) {
				$this->set_session_variables($account_information);
				if ($do_redirect) {
					header("Location: index.php\r\n\r\n");
					exit;
				}
		}else{
			$this->wrong_login = true;
		}
	}
	
	function is_wrong_login() {
		return ($this->wrong_login == true) ? true : false;	
	}

	/**
	 * Destroys the session and returns to the default page
	 */
	function do_logout() {
		$GLOBALS['user_session']->end_session();
		//header("location: index.php\r\n\r\n");
		//exit;
	}

	/**
	 * Gets the account information as well as the account type and organization information
	 * @return array of the account information
	 */
	function get_account_information($user_name, $password) {
		$sql = "SELECT ".DB_PREFIX."accounts.*, user_name AS account_name
							   FROM ".DB_PREFIX."accounts
							   WHERE
									user_name = '" . $user_name . "' AND 
									password = AES_ENCRYPT('" . $password . "', '" . DB_ENCRYPT_KEY . "')";
		return database_query($sql, DATA_ONLY, FIRST_ROW_ONLY);
	}

	/**
	 * Checks to see if the user is logged in
	 * @return a 1 if the user is logged in, 0 otherwise
	 */
	function is_logged_in() {
		$logged = $GLOBALS['user_session']->get_session_variable('session_account_id');
		return !empty($logged);
	}

	/**
	 * Checks to see if the user is logged in as a specific account type
	 * @return true if the user is logged in as specified account type, false otherwise
	 */
	function is_logged_in_as() {
		if (!$this->is_logged_in()) return false;

		$account_type = $GLOBALS['user_session']->get_session_variable("session_account_type");

		$types = func_get_args();
		foreach ($types as $type) {
			if ($account_type == $type) return true;
		}

		return false;
	}

	/**
	 * Sets the session variables and performs the login
	 * @param the account information
	 */
	function set_session_variables($account_information) {
		$GLOBALS['user_session']->set_session_variable("session_account_id", $account_information['id']);
		$GLOBALS['user_session']->set_session_variable("session_user_name", $account_information['user_name']);
		$GLOBALS['user_session']->set_session_variable("session_account_type", $account_information['account_type']);
	}

	/**
	 * Draws the login welcome message
	 */	
	function draw_welcome_message(){
		if($GLOBALS['user_session']->get_session_variable("session_user_name") != "")
			echo "<b>".ucfirst($GLOBALS['user_session']->get_session_variable("session_user_name"))." ".WELCOME_ADMIN."</b>";
	}

	/**
	 * Draws the login links and logout form
	 */
	function draw_login_links() {
		// Main Admin Links
		if ($this->is_logged_in_as('mainadmin')) {
			
			drawBlockTop();
				echo "<table class='moduletable' width='100%' border=0 cellspacing=0 cellpadding=0>
				<tr><TH vAlign=top><strong class='title_link'>General</strong></TH></TR>
				</table>";			
				echo "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php' target='_blank'>View Site</a><br>";
				echo "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=my_account'>My Account</a><br>";
			drawBlockBottom();
			echo "<br>";
			
			drawBlockTop();		
				echo "<table class='moduletable' width='100%' border=0 cellspacing=0 cellpadding=0>
				<tr><TH vAlign=top><strong class='title_link'>Menus Management</strong></TH></TR>
				</table>";			
				echo "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=menus_add'>Add New Menu</a><br>
				      &nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=menus'>Edit Menus</a><br>";
			drawBlockBottom();
			echo "<br>";

			drawBlockTop();
				echo "<table class='moduletable' width='100%' border=0 cellspacing=0 cellpadding=0>
				<tr><TH vAlign=top><strong class='title_link'>".PAGE_MANAGEMENT."</strong></TH></TR>
				</table>";			
				echo "&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=static_pages_add'>".PAGE_ADD_NEW."</a><br>
					&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=static_pages_edit&pk=home'>".PAGE_EDIT_HOME."</a><br>
					&nbsp;&nbsp;&nbsp;&#8226;&nbsp;<a class='main_menu_link' href='" . HTTPS_ADDRESS . "index.php?admin=static_pages'>".PAGE_EDIT_PAGES."</a><br>";
			drawBlockBottom();
		}

		// Logout
		if ($this->is_logged_in()){
			echo "<br><form action='" . HTTP_ADDRESS . "index.php' method='post'><input class='form_button' type='submit' name='submit_logout' value='Logout'></form>";
		}
	}
}
?>