<?php
session_start();

// Handle registration
if (isset($_POST["submit"])) {
    include('../connect.php');

    function clean_input($data) {
        return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
    }

    $a = clean_input($_POST['name']);       // Full Name
    $c = clean_input($_POST['username']);   // Username
    $d = clean_input($_POST['password']);   // Password (not hashed)
    $e1 = clean_input($_POST['contact']);   // Contact
    $b = 'Student';                         // Position
    $e = 'FormI';                           // Class
    $fa = '';                        // Default value for file_name

    if (!preg_match('/^[A-Za-z0-9 ]{3,50}$/', $a) || !preg_match('/^[A-Za-z0-9_]{3,20}$/', $c)) {
        $error = "Names and username must not contain special characters.";
    } elseif (empty($a) || empty($c) || empty($d) || empty($e1)) {
        $error = "Full name, Username, Password, and Contact are required.";
    } else {
        $stmt = $con->prepare("SELECT id FROM user WHERE username = ?");
        if (!$stmt) {
            $error = "Database error: " . $con->error;
        } else {
            $stmt->bind_param("s", $c);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows >= 1) {
                $error = "This username is already registered. Try another name.";
            } else {
                $stmt->close();

                // Insert user
                $stmt = $con->prepare("INSERT IGNORE INTO user (username, password, name, position, class, Contact, file_name) VALUES (?, ?, ?, ?, ?, ?, ?)");
                if (!$stmt) {
                    $error = "Prepare failed: " . $con->error;
                } else {
                    $stmt->bind_param("sssssss", $c, $d, $a, $b, $e, $e1, $fa);
                    if (!$stmt->execute()) {
                        $error = "Execute failed: " . $stmt->error;
                    } else {
                        $stmt->close();

                        // Auto login after registration
                        $stmt = $con->prepare("SELECT id, name, position FROM user WHERE username = ? AND password = ?");
                        if (!$stmt) {
                            $error = "Prepare failed (select): " . $con->error;
                        } else {
                            $stmt->bind_param("ss", $c, $d);
                            $stmt->execute();
                            $stmt->bind_result($id, $name, $position);

                            if ($stmt->fetch()) {
                                $_SESSION['SESS_MEMBER_ID'] = $id;
                                $_SESSION['SESS_FIRST_NAME'] = $name;
                                $_SESSION['SESS_LAST_NAME'] = $position;
                                header("location: index.php");
                                exit();
                            } else {
                                $error = "Login failed after registration. Please check user table.";
                            }
                            $stmt->close();
                        }
                    }
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Registration</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 4 -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.6.2/css/bootstrap.min.css">
  <style>
    body {
      background: linear-gradient(to right, #e0f7fa, #80deea);
      font-family: 'Segoe UI', sans-serif;
    }
    .card {
      max-width: 500px;
      margin: 60px auto;
      border: none;
      border-radius: 15px;
      box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
    .form-control {
      border-radius: 10px;
      padding: 18px 15px;
      font-size: 12px;
      box-shadow: none;
      border: 1px solid #ddd;
      transition: 0.3s ease-in-out;
      text-align: left;
    }
    .form-control:focus {
      border-color: #00acc1;
      box-shadow: 0 0 5px rgba(0, 172, 193, 0.3);
    }
    .btn-register {
      background: linear-gradient(135deg, #00796b, #00acc1);
      color: white;
      border: none;
      padding: 14px;
      border-radius: 10px;
      font-size: 16px;
      font-weight: bold;
      transition: 0.3s;
    }
    .btn-register:hover {
      background: linear-gradient(135deg, #00695c, #0097a7);
    }
    .info-note {
      font-size: 12px;
      color: #006064;
      text-align: center;
      margin-bottom: 15px;
    }
    .btn-link-block {
      display: block;
      width: 80%;
      text-align: center;
      background-color: #e0f2f1;
      border: 1px solid #00acc1;
      padding: 10px;
      border-radius: 8px;
      font-weight: 600;
      color: #00796b;
      text-decoration: none;
      margin-top: 15px;
    }
    .btn-link-block:hover {
      background-color: #b2ebf2;
      text-decoration: none;
    }
  </style>
</head>
<body>
<div align="center">
<div class="container">
  <div class="card p-4">
    <h3 align="center" class="text-center text-info mb-4">Student (user) initial Registration</h3>

    <?php if (!empty($error)): ?>
    <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" action="">
      <input type="text" name="name" class="form-control mb-4" placeholder="Full Student Names" required>
      <input type="text" name="username" class="form-control mb-4" placeholder="Username (use one name)" pattern="^[A-Za-z0-9_]{3,20}$" required>
      <input type="password" name="password" class="form-control mb-4" placeholder="Password (choose any)" required>
      <input type="text" name="contact" class="form-control mb-4" placeholder="Current Phone Number" required>

      <div class="info-note">
        <br>Tunza jina la kutumia na password maana utavitumia kuingia kwenye mfumo
      </div>

      <button type="submit" name="submit" class="btn btn-register btn-block">Click to Register Now (Gusa kujisajili sasa)</button>

      <a href="../index.php" class="btn-link-block">Login for Registered Users</a>
    </form>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.6.2/js/bootstrap.bundle.min.js"></script>
</div>
</body>
</html>
