<?php
// Start session
session_start();

// Brute-force protection setup
if (!isset($_SESSION['failed_login_attempts'])) {
    $_SESSION['failed_login_attempts'] = 0;
}
if (!isset($_SESSION['locked_until'])) {
    $_SESSION['locked_until'] = 0;
}

// Check if user is locked out
if ($_SESSION['locked_until'] > time()) {
    die("Too many failed login attempts. Please try again after " . ($_SESSION['locked_until'] - time()) . " seconds.");
}

// Array to store validation errors
$errmsg_arr = array();
$errflag = false;

// Time check
$older_date = "2019-07-08";
$end_date = "2030-03-31";
$today_date = date("Y-m-d");
$older = strtotime($older_date);
$end = strtotime($end_date);
$today = strtotime($today_date);

if ($today > $end) {
    echo "Muda wa kutumia Mfumo huu umemalizika. Tafadhali wasiliana na 0653 407 894 kupewa maelekezo namna ya kuendelea!.";
} elseif ($today < $older) {
    echo "Hakikisha tarehe ya Computer yako ni sahihi kabla ya kutumia mfumo huu";
} else {

    // Connect to MySQL
    include('connect.php');

    if (mysqli_connect_errno($link)) {
        die("Failed to connect to the Database: " . mysqli_connect_error());
    }

    // Sanitize input
    $login = mysqli_real_escape_string($link, $_POST['username']);
    $password = $_POST['password'];

    // Validate inputs
    if ($login == '') {
        $errmsg_arr[] = 'Username missing';
        $errflag = true;
    }
    if ($password == '') {
        $errmsg_arr[] = 'Password missing';
        $errflag = true;
    }

    if ($errflag) {
        $_SESSION['ERRMSG_ARR'] = $errmsg_arr;
        session_write_close();
        header("location: index.php");
        exit();
    }

    // Login query
    $qry = "SELECT * FROM user WHERE username='$login' AND password='$password'";
    $result = mysqli_query($link, $qry);

    // Handle login failure
    if (!$result || mysqli_num_rows($result) == 0) {
        $_SESSION['failed_login_attempts']++;

        // Log failed attempt
        $ip_address = !empty($_SERVER['HTTP_X_FORWARDED_FOR']) 
                      ? $_SERVER['HTTP_X_FORWARDED_FOR'] 
                      : $_SERVER['REMOTE_ADDR'];
        $user_agent = $_SERVER['HTTP_USER_AGENT'];

        $login_esc = mysqli_real_escape_string($link, $login);
        $ip_esc = mysqli_real_escape_string($link, $ip_address);
        $ua_esc = mysqli_real_escape_string($link, $user_agent);
        $location = file_get_contents("https://ipapi.co/$ip_address/city/");


        $log_fail = "INSERT INTO login_attempts (username, status, ip_address, user_agent, location)
                     VALUES ('$login_esc', 'failed', '$ip_esc', '$ua_esc','$location')";

        if (!mysqli_query($link, $log_fail)) {
            error_log("Logging failed login: " . mysqli_error($link));
        }

        // Lock after 5 attempts
        if ($_SESSION['failed_login_attempts'] >= 5) {
            $_SESSION['locked_until'] = time() + 60;
            die("Too many failed login attempts. You are temporarily blocked for 60 seconds.");
        }

        $errmsg_arr[] = 'Invalid username or password';
        $_SESSION['ERRMSG_ARR'] = $errmsg_arr;
        session_write_close();
        header("location: index.php");
        exit();
    }

    // Successful login
    $member = mysqli_fetch_assoc($result);

    // Reset brute-force counter
    $_SESSION['failed_login_attempts'] = 0;
    $_SESSION['locked_until'] = 0;

    session_regenerate_id();
    $_SESSION['SESS_MEMBER_ID']  = $member['id'];
    $_SESSION['SESS_DB_NAME']    = $member['username'];
    $_SESSION['SESS_FIRST_NAME'] = $member['name'];
    $_SESSION['SESS_LAST_NAME']  = $member['position'];
    $_SESSION['SESS_CLASS_NAME'] = $member['class'];
    $_SESSION['SESS_PASS_NAME']  = $member['password'];
    $_SESSION['user_id']         = $member['id'];

    // Log successful login
    $ip_address = !empty($_SERVER['HTTP_X_FORWARDED_FOR']) 
                  ? $_SERVER['HTTP_X_FORWARDED_FOR'] 
                  : $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'];

    $login_esc = mysqli_real_escape_string($link, $login);
    $ip_esc = mysqli_real_escape_string($link, $ip_address);
    $ua_esc = mysqli_real_escape_string($link, $user_agent);
    $location = file_get_contents("https://ipapi.co/$ip_address/city/");

    $log_success = "INSERT INTO login_attempts (username, status, ip_address, user_agent, location)
                    VALUES ('$login_esc', 'success', '$ip_esc', '$ua_esc', '$location')";
    if (!mysqli_query($link, $log_success)) {
        error_log("Logging successful login: " . mysqli_error($link));
    }

    // Optional: keep original log
    $user_id = $_SESSION['user_id'];
    $user_name = $_SESSION['SESS_FIRST_NAME'];
    $user_logs = "INSERT IGNORE INTO user_logs (user_id, user_name, event_type, ip_address, user_agent)
                  VALUES ('$user_id','$user_name', 'login', '$ip_esc', '$ua_esc')";
    mysqli_query($link, $user_logs);

    session_write_close();
    header("location: main/index.php");
    exit();
}
?>
