<?php
session_start();
unset($_SESSION['SESS_MEMBER_ID']);
unset($_SESSION['SESS_FIRST_NAME']);
unset($_SESSION['SESS_LAST_NAME']);
unset($_SESSION['SESS_CLASS_NAME']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Online Application System</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="shortcut icon" href="main/images/pos.jpg">
  <link href="main/css/bootstrap.css" rel="stylesheet">
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

  <link href="main/css/bootstrap-responsive.css" rel="stylesheet">

  <style>
    body {
      background: #f4f4f4;
      font-family: 'Segoe UI', sans-serif;
      padding-top: 40px;
      padding-bottom: 20px;
      color: #000;
    }

    .login-container {
      max-width: 400px;
      margin: 0 auto;
      padding: 25px;
      background: white;
      border-radius: 12px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }

    .form-control {
      border-radius: 20px;
      font-size: 14px;
      padding: 12px;
      margin: 0 auto 15px auto;
      display: block;
      width: 50%;
      max-width: 320px;
    }

    .btn-login {
      width: 100%;
      padding: 12px;
      font-weight: bold;
      border-radius: 8px;
    }

    .btn-custom {
      display: block;
      margin: 10px 0;
      font-weight: bold;
      border-radius: 8px;
    }

    .error-msg {
      color: red;
      font-size: 14px;
      text-align: center;
    }

    .enquiry-box {
      text-align: center;
      font-size: 14px;
      margin-top: 20px;
    }

    .style1 {color: #000000}
    .style2 {
      text-align: center;
      font-size: 16px;
      font-weight: bold;
      color: #666666;
      margin-bottom: 20px;
      font-family: Georgia, "Times New Roman", Times, serif;
    }

    .style3 {color: #666666}

    /* Password field with eye icon */
    .password-container {
      position: relative;
      width: 62%;
      max-width: 320px;
      margin: 0 auto 15px auto;
    }

    .password-container input {
      width: 60%;
      padding-right: 40px;
    }

    .password-container i {
      position: absolute;
      top: 50%;
      right: 15px;
      transform: translateY(-50%);
      cursor: pointer;
      color: #888;
    }
  </style>
</head>
<body>
<div align="center">
<div class="container">
  <div class="login-container">

    <div class="style2">ONLINE APPLICATION FOR ADMISSION</div>

    <?php
    if (isset($_SESSION['ERRMSG_ARR']) && is_array($_SESSION['ERRMSG_ARR']) && count($_SESSION['ERRMSG_ARR']) > 0) {
      foreach ($_SESSION['ERRMSG_ARR'] as $msg) {
        echo '<div class="error-msg">', htmlspecialchars($msg), '</div>';
      }
      unset($_SESSION['ERRMSG_ARR']);
    }
    ?>

<a href="main/adduser.php" class="btn btn-warning btn-custom style1">
  <i class="fa fa-user-plus" style="font-size: 18px; margin-right: 6px;"></i>
  Start Here - New Applicants<br>(Jiandikishe hapa Waombaji Wapya)
</a>




    <form action="login.php" method="post">
      
      <br>
<p class="style3" style="text-align:center; font-weight:bold;">
  <i class="fa fa-lock" style="margin-right: 6px;"></i>
  Login for Registered Only<br>* Kwa Waliojisajili Tayari *
</p>


      <div class="form-group">
        <input type="text" name="username" class="form-control" placeholder="Type Username" required>
      </div>

      <!-- Password with eye toggle -->
      <div class="form-group password-container">
        <input type="password" name="password" id="password" class="form-control" placeholder="Type Password" required>
        <i class="fa fa-eye" id="togglePassword"></i>
      </div>

      <button type="submit" class="btn btn-primary btn-login">
        <i class="icon-signin"></i> Login (Ingia)
      </button>
    </form>

    <div class="enquiry-box">
      <a href="#" class="btn btn-warning btn-custom style1">
        Enquiry (Kuuliza au maelekezo zaidi)<br>0653 407 894<br>0719 843 205
      </a>
    </div>
  </div>
</div>
</div>

<!-- JavaScript to toggle password visibility -->
<script>
  const togglePassword = document.getElementById('togglePassword');
  const passwordField = document.getElementById('password');

  togglePassword.addEventListener('click', function () {
    const type = passwordField.type === 'password' ? 'text' : 'password';
    passwordField.type = type;
    this.classList.toggle('fa-eye');
    this.classList.toggle('fa-eye-slash');
  });
</script>

</body>
</html>
