<?php
class StaticPages {
	protected $page_key;
	protected $page;
	public $error;
	
	function StaticPages($page_key = "") {
		$this->page_key = $page_key;
		if($this->page_key!=""){
			$sql = "SELECT * FROM ".DB_PREFIX."static_pages WHERE page_key = '".$this->page_key."'";
			$this->page = database_query($sql,DATA_ONLY,1);
		}else{
			$this->page['page_title'] = "";
			$this->page['page_text'] = "";
			$this->page['menu_id'] = "0";
			$this->page['menu_link'] = "";
		}
	}
	
	public function DrawTitle(){
		if(isset($this->page['page_title'])){
			$page_title = $this->getDataDecoded($this->page['page_title']);
			draw_title_bar($page_title);
		}
	}

	public function DrawText(){
		if(isset($this->page['page_text'])){
			$page_text = $this->getDataDecodedText($this->page['page_text']);
			echo $page_text;
		}
	}
	
	public function getTitle(){
		if(isset($this->page['page_title'])){
			$page_title = $this->getDataDecoded($this->page['page_title']);
			return $page_title;
		}else return "";
	}
	
	public function getMenuId(){
		if(isset($this->page['menu_id'])) return $this->page['menu_id'];
		return "";
	}

	public function getMenuLink(){
		if(isset($this->page['menu_link'])){
			$menu_link = $this->getDataDecoded($this->page['menu_link']);
			return $menu_link;
		}else return "";
	}
	
	public function getKey(){
		return $this->page_key;
	}
	
	public function getText(){
		if(isset($this->page['page_text'])){
			$page_text = $this->getDataDecodedText($this->page['page_text']);
			return $page_text;
		}else return "";
	}
	
	function getAll() {
		$sql = "SELECT pages.*, menus.* 
				FROM ".DB_PREFIX."static_pages pages 
					LEFT OUTER JOIN ".DB_PREFIX."menus menus ON pages.menu_id=menus.id
				WHERE pages.page_key!='home'
				ORDER BY menus.menu_order ASC";
		return database_query($sql,DATA_AND_ROWS);
	}
	
	function pageUpdate($params = Array()) {
		// Get input parameters
		if(isset($params['page_title']))$this->page['page_title'] = $params['page_title'];
		if(isset($params['page_text']))$this->page['page_text'] = $params['page_text'];
		if(isset($params['menu_id']))$this->page['menu_id'] = $params['menu_id'];
		if(isset($params['menu_link']))$this->page['menu_link'] = $params['menu_link'];
		
		// Menu link cannot be more then 18 characters
		if (strlen($this->page['menu_link'])>18) {
			$this->error = PAGE_LINK_TOO_LONG;
			return false;
		}
		
		$page_text = $this->getDataEncodedText($this->page['page_text']); 
		$menu_link = $this->getDataEncoded($this->page['menu_link']); 
		$page_title = $this->getDataEncoded($this->page['page_title']); 
		
		if(isset($this->page['page_key'])){
			$sql = "UPDATE ".DB_PREFIX."static_pages
					SET 
						page_title = '".$page_title."',
						page_text = '".$page_text."',
						menu_id = ".intval($this->page['menu_id']).",
						menu_link = '".$menu_link."'
					WHERE page_key = '".$this->page['page_key']."'";
			if (database_void_query($sql)){
				return true;
			} else {
				$this->error = TRY_LATER;
				return false;
			}
		}else{
			$this->error = PAGE_UNKNOWN;
			return false;
		}
	}
	
	function pageCreate($params = Array()) {
		// Get input parameters
		if(isset($params['page_key']))$this->page['page_key'] = $params['page_key'];
		if(isset($params['page_title']))$this->page['page_title'] = $params['page_title'];
		if(isset($params['page_text']))$this->page['page_text'] = $params['page_text'];
		if(isset($params['menu_id']))$this->page['menu_id'] = $params['menu_id'];
		if(isset($params['menu_link']))$this->page['menu_link'] = $params['menu_link'];

		// Menu link cannot be more then 18 characters
		if (strlen($this->page['menu_link'])>18) {
			$this->error = PAGE_LINK_TOO_LONG;
			return false;
		}
		
		// Prevent creating of empty records in our 'static pages' table
		if($this->page['page_title']!=""){
		$page_text = $this->getDataEncodedText($this->page['page_text']); 
		$menu_link = $this->getDataEncoded($this->page['menu_link']); 
		$page_title = $this->getDataEncoded($this->page['page_title']); 
		
			
			// Create new record
			$sql = "INSERT INTO ".DB_PREFIX."static_pages(id, page_key, page_title, page_text, menu_id, menu_link)
					VALUES(
						NULL,
						'',
						'".$page_title."',
						'".$page_text."',
						".intval($this->page['menu_id']).",
						'".$menu_link."'
					)";
				if (database_void_query($sql)){

					// Update page_key
					$last_insert_id = mysql_insert_id();
					$sql = "UPDATE ".DB_PREFIX."static_pages 
						SET page_key='".$this->page['page_key'].$last_insert_id."'
						WHERE id=".intval($last_insert_id)."";
					if (database_void_query($sql)){
						return true;
					}else{
						$this->error = TRY_LATER;
						return false;
					}
				} else {
					$this->error = TRY_LATER;
					return false;
				}				
		}else{
			$this->error = PAGE_HEADER_EMPTY;
			return false;
		}
	}

	function pageDelete($page_key = "") {
		// First, check that the page exists
		$sql = "SELECT * FROM ".DB_PREFIX."static_pages WHERE page_key = '".$page_key."'";
		if(database_query($sql,DATA_ONLY)){
			// Delete page
			$sql = "DELETE FROM ".DB_PREFIX."static_pages WHERE page_key = '".$page_key."'";
			if(database_void_query($sql)) return true;
		}
		$this->error = TRY_LATER;
		return false;
	}
	
	private function getDataEncodedText($string = ""){
		return $string;
	}
	
	private function getDataDecodedText($string = ""){
		$string = str_replace('\"', '"', $string); // double quotation mark
		$string = str_replace("\'", "'", $string); // single quotation mark                        
		return $string;
	}
	
	private function getDataEncoded($string = ""){
		$string = str_replace("\'", "'", $string);
		$string = str_replace('\"', '"', $string);			
		$string = str_replace("&#034;", "'", $string);
		$string = str_replace('&#039;', '"', $string);			
		return $string;
	}
	
	private function getDataDecoded($string = ""){
		$string = str_replace('\"', "&#034;", $string); // double quotation mark
		$string = str_replace("\'", "&#039;", $string); // single quotation mark                        
		$string = str_replace('"', "&#034;", $string); // double quotation mark
		$string = str_replace("'", "&#039;", $string); // single quotation mark                        
		return $string;
	}
}
?>